/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.CompStatExplain;
import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.HasStatusDependents;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.eui.MultiLineLabel;
import ibm.nways.jdm.eui.PropertyBook;
import ibm.nways.jdm.eui.PropertySection;
import java.awt.Button;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

class FolderStatusDestPanel
extends DestinationPropBook {
    private Object context;
    private RemoteModel model;
    private String title;
    private NavigationFolder folder;
    private ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm.FolderStatusDestPanelResources", Locale.getDefault());

    public void addSections() {
    }

    public void initForFolder(NavigationFolder navigationFolder) {
        this.folder = navigationFolder;
        NavFolderStatus navFolderStatus = new NavFolderStatus();
        this.setTitle(String.valueOf(navigationFolder.getLabel()) + this.myResources.getString("titleTail"));
        this.addSection(this.myResources.getString("folderSec"), navFolderStatus);
        this.addSection(this.myResources.getString("dependSec"), new DepStatus());
    }

    public NavigationFolder getFolder() {
        return this.folder;
    }

    private ResourceBundle getMyResources() {
        return this.myResources;
    }

    FolderStatusDestPanel() {
    }

    final /* synthetic */ ResourceBundle access$0() {
        return this.getMyResources();
    }

    public class NavFolderStatus
    extends PropertySection {
        private GridBagLayout gbl = new GridBagLayout();
        private Label compStatLabel;
        private Label compStatValue;
        private Label policyLabel;
        private Label policyValue;
        private Label explainLabel;
        private MultiLineLabel explainArea;
        private HasStatusDependents hsd;
        private Status status;

        public NavFolderStatus() {
            FolderStatusDestPanel.this = FolderStatusDestPanel.this;
            this.setLayout(this.gbl);
            this.hsd = (HasStatusDependents)((Object)FolderStatusDestPanel.this.getFolder().getStatus());
            this.status = (Status)((Object)this.hsd);
            this.compStatLabel = new Label(FolderStatusDestPanel.this.access$0().getString("compStatLabel"));
            this.compStatLabel.setForeground(JmaColors.textText);
            GridBagConstraints gridBagConstraints = this.makeConstraints(0, 0, 1, 1);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.ipady = 10;
            gridBagConstraints.anchor = 17;
            this.gbl.setConstraints(this.compStatLabel, gridBagConstraints);
            this.add(this.compStatLabel);
            this.compStatValue = new Label(this.status.getStatusType().toString());
            this.compStatValue.setForeground(JmaColors.textText);
            gridBagConstraints = this.makeConstraints(1, 0, 1, 1);
            gridBagConstraints.anchor = 17;
            this.gbl.setConstraints(this.compStatValue, gridBagConstraints);
            this.add(this.compStatValue);
            this.policyLabel = new Label(FolderStatusDestPanel.this.access$0().getString("policyLabel"));
            this.policyLabel.setForeground(JmaColors.textText);
            gridBagConstraints = this.makeConstraints(0, 1, 1, 1);
            gridBagConstraints.ipady = 10;
            gridBagConstraints.anchor = 17;
            this.gbl.setConstraints(this.policyLabel, gridBagConstraints);
            this.add(this.policyLabel);
            this.policyValue = new Label(this.hsd.getManagerLabel(Locale.getDefault()));
            this.policyValue.setForeground(JmaColors.textText);
            gridBagConstraints = this.makeConstraints(1, 1, 1, 1);
            gridBagConstraints.anchor = 17;
            this.gbl.setConstraints(this.policyValue, gridBagConstraints);
            this.add(this.policyValue);
            this.explainLabel = new Label(FolderStatusDestPanel.this.access$0().getString("compExpl"));
            this.explainLabel.setForeground(JmaColors.textText);
            gridBagConstraints = this.makeConstraints(0, 2, 0, 1);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(15, 0, 5, 0);
            this.gbl.setConstraints(this.explainLabel, gridBagConstraints);
            this.add(this.explainLabel);
            this.explainArea = new MultiLineLabel("", 10, 10);
            gridBagConstraints = this.makeConstraints(0, 3, 0, 1);
            gridBagConstraints.fill = 2;
            this.gbl.setConstraints(this.explainArea, gridBagConstraints);
            this.add(this.explainArea);
            this.update();
        }

        public void update() {
            String string = null;
            I18NString i18NString = this.status.getExplanation();
            if (i18NString != null) {
                string = i18NString.getTranslation();
            }
            if (string == null || string.length() == 0) {
                string = FolderStatusDestPanel.this.access$0().getString("noExpl");
            }
            this.explainArea.setText(string);
        }

        public void reset() {
            Status status = FolderStatusDestPanel.this.getFolder().getStatus();
            System.out.println("Checking folder status");
            status.check();
            this.update();
        }

        private GridBagConstraints makeConstraints(int n, int n2, int n3, int n4) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            return gridBagConstraints;
        }
    }

    public class DepStatus
    extends PropertySection
    implements ItemListener {
        private GridBagLayout gbl;
        private Label dependLabel;
        private List dependList;
        private Label explainLabel;
        private MultiLineLabel explainArea;
        private ScrollPane explainScroller;
        private Vector folderStatusItems;
        private Vector textItems;
        private Button explItemButton;
        private Status selectedDepStatus;
        private ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm.FolderStatusDestPanelResources", Locale.getDefault());

        public DepStatus() {
            FolderStatusDestPanel.this = FolderStatusDestPanel.this;
            this.gbl = new GridBagLayout();
            this.setLayout(this.gbl);
            this.dependLabel = new Label(FolderStatusDestPanel.this.access$0().getString("selectDep"));
            this.dependLabel.setForeground(JmaColors.textText);
            GridBagConstraints gridBagConstraints = this.makeConstraints(0, 2, 1, 1);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(15, 0, 5, 0);
            this.gbl.setConstraints(this.dependLabel, gridBagConstraints);
            this.add(this.dependLabel);
            this.dependList = new List();
            this.dependList.setMultipleMode(false);
            this.dependList.addItemListener(this);
            this.dependList.setBackground(PropertyBook.selListBackColor);
            this.update();
            gridBagConstraints = this.makeConstraints(0, 3, 0, 1);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            this.gbl.setConstraints(this.dependList, gridBagConstraints);
            this.add(this.dependList);
            this.explainLabel = new Label(FolderStatusDestPanel.this.access$0().getString("dependExpl"));
            this.explainLabel.setForeground(JmaColors.textText);
            gridBagConstraints = this.makeConstraints(0, 4, 0, 1);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(15, 0, 5, 0);
            this.gbl.setConstraints(this.explainLabel, gridBagConstraints);
            this.add(this.explainLabel);
            this.explainArea = new MultiLineLabel("", 15, 10);
            this.explainArea.setForeground(JmaColors.textText);
            this.explainScroller = new ScrollPane();
            this.explainScroller.add(this.explainArea);
            gridBagConstraints = this.makeConstraints(0, 5, 0, 1);
            gridBagConstraints.fill = 2;
            this.gbl.setConstraints(this.explainScroller, gridBagConstraints);
            this.add(this.explainScroller);
            this.explItemButton = new Button(FolderStatusDestPanel.this.access$0().getString("explainItemButton"));
            this.explItemButton.setForeground(SystemColor.controlText);
            this.explItemButton.setBackground(SystemColor.control);
            this.explItemButton.addActionListener(new ExplainMoreDetailButton(FolderStatusDestPanel.this.getBrowser()));
            this.explItemButton.setEnabled(false);
            gridBagConstraints = this.makeConstraints(0, 7, 2, 1);
            gridBagConstraints.insets = new Insets(15, 0, 5, 0);
            this.gbl.setConstraints(this.explItemButton, gridBagConstraints);
            this.add(this.explItemButton);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this.selectedDepStatus = (Status)this.folderStatusItems.elementAt((Integer)itemEvent.getItem());
                String string = null;
                I18NString i18NString = this.getSelectedDepStatus().getExplanation();
                if (i18NString != null) {
                    string = i18NString.getTranslation();
                }
                if (string == null || string.length() == 0) {
                    string = FolderStatusDestPanel.this.access$0().getString("noExpl");
                }
                this.explainArea.setText(string);
                this.explainScroller.setVisible(false);
                Rectangle rectangle = this.explainScroller.getBounds();
                this.explainScroller.setBounds(rectangle.x, rectangle.y, rectangle.width - 3, rectangle.height - 3);
                this.explainScroller.invalidate();
                this.explainScroller.validate();
                this.explainScroller.setVisible(true);
                if (this.getSelectedDepStatus() instanceof HasStatusDependents) {
                    this.explItemButton.setEnabled(true);
                } else {
                    this.explItemButton.setEnabled(false);
                }
                this.invalidate();
                this.validate();
            }
        }

        private Status getSelectedDepStatus() {
            return this.selectedDepStatus;
        }

        private void update() {
            this.dependList.removeAll();
            this.initDependents();
            Enumeration enumeration = this.textItems.elements();
            while (enumeration.hasMoreElements()) {
                this.dependList.add((String)enumeration.nextElement());
            }
        }

        private void initDependents() {
            this.folderStatusItems = new Vector();
            this.textItems = new Vector();
            Enumeration enumeration = ((HasStatusDependents)((Object)FolderStatusDestPanel.this.getFolder().getStatus())).getDependents().elements();
            while (enumeration.hasMoreElements()) {
                Status status = (Status)enumeration.nextElement();
                I18NString i18NString = status.getName();
                String string = i18NString == null ? this.myResources.getString("noStatusName") : i18NString.getTranslation();
                String string2 = String.valueOf(string) + ": " + status.getStatusType().toString();
                this.textItems.addElement(string2);
                this.folderStatusItems.addElement(status);
            }
        }

        private GridBagConstraints makeConstraints(int n, int n2, int n3, int n4) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            return gridBagConstraints;
        }

        public void reset() {
            this.update();
        }

        final /* synthetic */ Status access$0() {
            return this.getSelectedDepStatus();
        }

        class ExplainMoreDetailButton
        implements ActionListener {
            private BrowserApplet browser;

            public ExplainMoreDetailButton(BrowserApplet browserApplet) {
                DepStatus.this = DepStatus.this;
                this.browser = browserApplet;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (DepStatus.this.access$0() instanceof HasStatusDependents) {
                    CompStatExplain compStatExplain = new CompStatExplain(this.browser, DepStatus.this.access$0());
                    compStatExplain.show();
                }
            }
        }
    }
}

